package com.ejie.ab04b.model.solicitud;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.model.ApartadoAnexoI;
import com.ejie.ab04b.model.ClaseCentroTrabajo;
import com.ejie.ab04b.model.ModalidadOrganizacionPreventiva;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Pais;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * SolicAperturas generated by UDA, 11-abr-2017 8:58:35.
 * 
 * @author UDA
 */

public class SolicAperturas implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Primary key
	private Long idSolicitud056;

	private Long tiposol056;
	private String anoape056;
	private Integer numape056;
	private Date fecpre056;
	private String nueva056;
	private String titrepr056;
	private String tipdoc056;
	private String numdoc056;
	private String nomemp056;
	private Pais paisemp056;
	private Provincia prvemp056;
	private Municipio munemp056;
	private String dmunemp056;
	private String diremp056;
	private String cpoemp056;
	private String tlfemp056;
	private String cnaeemp056;
	private String entiat056;
	private String tipape056;
	private String nomctr056;
	private Provincia prvctr056;
	private Municipio munctr056;
	private Localidad locctr056;
	private String dirctr056;
	private String cpoctr056;
	private String tlfctr056;
	private String faxctr056;
	private String emailctr056;
	private String cnaectr056;
	private String prvss056;
	private String numss056;
	private String digss056;
	private Date fecini056;
	private Long trbhom056;
	private Long trbmuj056;
	private Long trbtot056;
	private String clasctr056;
	private String descobr056;
	private Integer superf056;
	private String planseg056;
	private String canalplan056;
	private String planpres056;
	private String proytec056;
	private String descmaq056;
	private BigDecimal poten056;
	private String indanx056;
	private String apdoanx056;
	private String destrab056;
	private String indobra056;
	private SolicObra obra;
	private Integer codctr056;
	private String lotemnt056;
	private String asgosl056;
	private String codentiat056;
	private String cnaectr93056;
	private String cnaeemp93056;
	private Integer modpre056;
	private Long numcnt056;
	private String evalpres056;
	private String canaleval056;
	private String regemp056;
	private String regemp1;
	private String regemp2;
	private String regemp3;
	private String tipdocrepresentante056;
	private String numdocrepresentante056;
	private String nomrepresentante056;
	private String tlfrepresentante056;
	private String terape056;
	private String forpre056;
	private String folderId056;
	private SolicDatosNotificacion datosNotificacion;
	private String estadoSolicitud056;
	private String numregistro056;

	private List<SolicDocAperturas> listaDocumentos;
	private List<SolicProyectista> listaProyectistas;
	private List<SolicCoordinador> listaCoordinadoresP;
	private List<SolicCoordinador> listaCoordinadoresE;
	private List<SolicPromotor> listaPromotores;
	private List<SolicDatosAviso> listaDatosAviso;

	// Criterios filtrado
	private boolean filtroBorradoresUsuario;
	private String filtroNifUsuario;

	private String descCnaeEmp;
	private String descCnaeCtr;
	private ClaseCentroTrabajo claseCentro;
	private ModalidadOrganizacionPreventiva modalidadOrgPrev;
	private ApartadoAnexoI anexoI;

	/**
	 * Method 'SolicAperturas'.
	 */
	public SolicAperturas() {
	}

	/**
	 * Method 'SolicAperturas'.
	 * 
	 *  idSolicitud056
	 *            Long
	 *
	 * @param idSolicitud056 the id solicitud 056
	 */
	public SolicAperturas(Long idSolicitud056) {
		this.idSolicitud056 = idSolicitud056;
	}

	/**
	 * Method 'SolicAperturas'.
	 * 
	 *  idSolicitud056
	 *            Long
	 *  tiposol056
	 *            Long
	 *  anoape056
	 *            String
	 *  numape056
	 *            Integer
	 *  fecpre056
	 *            Date
	 *  nueva056
	 *            String
	 *  tipdoc056
	 *            String
	 *  numdoc056
	 *            String
	 *  nomemp056
	 *            String
	 *  paisemp056
	 *            String
	 *  prvemp056
	 *            String
	 *  munemp056
	 *            String
	 *  dmunemp056
	 *            String
	 *  diremp056
	 *            String
	 *  cpoemp056
	 *            String
	 *  tlfemp056
	 *            String
	 *  cnaeemp056
	 *            String
	 *  entiat056
	 *            String
	 *  tipape056
	 *            String
	 *  nomctr056
	 *            String
	 *  prvctr056
	 *            String
	 *  munctr056
	 *            String
	 *  locctr056
	 *            String
	 *  dirctr056
	 *            String
	 *  cpoctr056
	 *            String
	 *  tlfctr056
	 *            String
	 *  faxctr056
	 *            String
	 *  emailctr056
	 *            String
	 *  cnaectr056
	 *            String
	 *  prvss056
	 *            String
	 *  numss056
	 *            String
	 *  digss056
	 *            String
	 *  fecini056
	 *            Date
	 *  trbhom056
	 *            Long
	 *  trbmuj056
	 *            Long
	 *  trbtot056
	 *            Long
	 *  clasctr056
	 *            String
	 *  descobr056
	 *            String
	 *  superf056
	 *            Integer
	 *  planseg056
	 *            String
	 *  canalplan056
	 *            String
	 *  planpres056
	 *            String
	 *  proytec056
	 *            String
	 *  descmaq056
	 *            String
	 *  poten056
	 *            BigDecimal
	 *  indanx056
	 *            String
	 *  apdoanx056
	 *            String
	 *  destrab056
	 *            String
	 *  indobra056
	 *            String
	 *  obra
	 *            SolicObra
	 *  codctr056
	 *            Integer
	 *  lotemnt056
	 *            String
	 *  asgosl056
	 *            String
	 *  codentiat056
	 *            String
	 *  cnaectr93056
	 *            String
	 *  cnaeemp93056
	 *            String
	 *  modpre056
	 *            Integer
	 *  numcnt056
	 *            Long
	 *  evalpres056
	 *            String
	 *  canaleval056
	 *            String
	 *  regemp056
	 *            String
	 *  numdocrepresentante056
	 *            String
	 *  tlfrepresentante056
	 *            String
	 *  terape056
	 *            String
	 *  forpre056
	 *            String
	 *  folderId056
	 *            String
	 *  datosNotificacion
	 *            SolicDatosNotificacion
	 *  estadoSolicitud056
	 *            String
	 *  titrepr056
	 *            String
	 *  tipdocrepresentante056
	 *            String
	 *  nomrepresentante056
	 *            String
	 *  numregistroO56
	 *            String
	 *
	 * @param idSolicitud056 the id solicitud 056
	 * @param tiposol056 the tiposol 056
	 * @param anoape056 the anoape 056
	 * @param numape056 the numape 056
	 * @param fecpre056 the fecpre 056
	 * @param nueva056 the nueva 056
	 * @param tipdoc056 the tipdoc 056
	 * @param numdoc056 the numdoc 056
	 * @param nomemp056 the nomemp 056
	 * @param paisemp056 the paisemp 056
	 * @param prvemp056 the prvemp 056
	 * @param munemp056 the munemp 056
	 * @param dmunemp056 the dmunemp 056
	 * @param diremp056 the diremp 056
	 * @param cpoemp056 the cpoemp 056
	 * @param tlfemp056 the tlfemp 056
	 * @param cnaeemp056 the cnaeemp 056
	 * @param entiat056 the entiat 056
	 * @param tipape056 the tipape 056
	 * @param nomctr056 the nomctr 056
	 * @param prvctr056 the prvctr 056
	 * @param munctr056 the munctr 056
	 * @param locctr056 the locctr 056
	 * @param dirctr056 the dirctr 056
	 * @param cpoctr056 the cpoctr 056
	 * @param tlfctr056 the tlfctr 056
	 * @param faxctr056 the faxctr 056
	 * @param emailctr056 the emailctr 056
	 * @param cnaectr056 the cnaectr 056
	 * @param prvss056 the prvss 056
	 * @param numss056 the numss 056
	 * @param digss056 the digss 056
	 * @param fecini056 the fecini 056
	 * @param trbhom056 the trbhom 056
	 * @param trbmuj056 the trbmuj 056
	 * @param trbtot056 the trbtot 056
	 * @param clasctr056 the clasctr 056
	 * @param descobr056 the descobr 056
	 * @param superf056 the superf 056
	 * @param planseg056 the planseg 056
	 * @param canalplan056 the canalplan 056
	 * @param planpres056 the planpres 056
	 * @param proytec056 the proytec 056
	 * @param descmaq056 the descmaq 056
	 * @param poten056 the poten 056
	 * @param indanx056 the indanx 056
	 * @param apdoanx056 the apdoanx 056
	 * @param destrab056 the destrab 056
	 * @param indobra056 the indobra 056
	 * @param obra the obra
	 * @param codctr056 the codctr 056
	 * @param lotemnt056 the lotemnt 056
	 * @param asgosl056 the asgosl 056
	 * @param codentiat056 the codentiat 056
	 * @param cnaectr93056 the cnaectr 93056
	 * @param cnaeemp93056 the cnaeemp 93056
	 * @param modpre056 the modpre 056
	 * @param numcnt056 the numcnt 056
	 * @param evalpres056 the evalpres 056
	 * @param canaleval056 the canaleval 056
	 * @param regemp056 the regemp 056
	 * @param numdocrepresentante056 the numdocrepresentante 056
	 * @param tlfrepresentante056 the tlfrepresentante 056
	 * @param terape056 the terape 056
	 * @param forpre056 the forpre 056
	 * @param folderId056 the folder id 056
	 * @param datosNotificacion the datos notificacion
	 * @param estadoSolicitud056 the estado solicitud 056
	 * @param titrepr056 the titrepr 056
	 * @param tipdocrepresentante056 the tipdocrepresentante 056
	 * @param nomrepresentante056 the nomrepresentante 056
	 * @param numregistro056 the numregistro 056
	 */
	public SolicAperturas(Long idSolicitud056, Long tiposol056,
			String anoape056, Integer numape056, Date fecpre056,
			String nueva056, String tipdoc056, String numdoc056,
			String nomemp056, Pais paisemp056, Provincia prvemp056,
			Municipio munemp056, String dmunemp056, String diremp056,
			String cpoemp056, String tlfemp056, String cnaeemp056,
			String entiat056, String tipape056, String nomctr056,
			Provincia prvctr056, Municipio munctr056, Localidad locctr056,
			String dirctr056, String cpoctr056, String tlfctr056,
			String faxctr056, String emailctr056, String cnaectr056,
			String prvss056, String numss056, String digss056, Date fecini056,
			Long trbhom056, Long trbmuj056, Long trbtot056, String clasctr056,
			String descobr056, Integer superf056, String planseg056,
			String canalplan056, String planpres056, String proytec056,
			String descmaq056, BigDecimal poten056, String indanx056,
			String apdoanx056, String destrab056, String indobra056,
			SolicObra obra, Integer codctr056, String lotemnt056,
			String asgosl056, String codentiat056, String cnaectr93056,
			String cnaeemp93056, Integer modpre056, Long numcnt056,
			String evalpres056, String canaleval056, String regemp056,
			String numdocrepresentante056, String tlfrepresentante056,
			String terape056, String forpre056, String folderId056,
			SolicDatosNotificacion datosNotificacion,
			String estadoSolicitud056, String titrepr056,
			String tipdocrepresentante056, String nomrepresentante056,
			String numregistro056) {

		this.idSolicitud056 = idSolicitud056;
		this.tiposol056 = tiposol056;
		this.anoape056 = anoape056;
		this.numape056 = numape056;
		this.fecpre056 = fecpre056;
		this.nueva056 = nueva056;
		this.titrepr056 = titrepr056;
		this.tipdoc056 = tipdoc056;
		this.numdoc056 = numdoc056;
		this.nomemp056 = nomemp056;
		this.paisemp056 = paisemp056;
		this.prvemp056 = prvemp056;
		this.munemp056 = munemp056;
		this.dmunemp056 = dmunemp056;
		this.diremp056 = diremp056;
		this.cpoemp056 = cpoemp056;
		this.tlfemp056 = tlfemp056;
		this.cnaeemp056 = cnaeemp056;
		this.entiat056 = entiat056;
		this.tipape056 = tipape056;
		this.nomctr056 = nomctr056;
		this.prvctr056 = prvctr056;
		this.munctr056 = munctr056;
		this.locctr056 = locctr056;
		this.dirctr056 = dirctr056;
		this.cpoctr056 = cpoctr056;
		this.tlfctr056 = tlfctr056;
		this.faxctr056 = faxctr056;
		this.emailctr056 = emailctr056;
		this.cnaectr056 = cnaectr056;
		this.prvss056 = prvss056;
		this.numss056 = numss056;
		this.digss056 = digss056;
		this.fecini056 = fecini056;
		this.trbhom056 = trbhom056;
		this.trbmuj056 = trbmuj056;
		this.trbtot056 = trbtot056;
		this.clasctr056 = clasctr056;
		this.descobr056 = descobr056;
		this.superf056 = superf056;
		this.planseg056 = planseg056;
		this.canalplan056 = canalplan056;
		this.planpres056 = planpres056;
		this.proytec056 = proytec056;
		this.descmaq056 = descmaq056;
		this.poten056 = poten056;
		this.indanx056 = indanx056;
		this.apdoanx056 = apdoanx056;
		this.destrab056 = destrab056;
		this.indobra056 = indobra056;
		this.obra = obra;
		this.codctr056 = codctr056;
		this.lotemnt056 = lotemnt056;
		this.asgosl056 = asgosl056;
		this.codentiat056 = codentiat056;
		this.cnaectr93056 = cnaectr93056;
		this.cnaeemp93056 = cnaeemp93056;
		this.modpre056 = modpre056;
		this.numcnt056 = numcnt056;
		this.evalpres056 = evalpres056;
		this.canaleval056 = canaleval056;
		this.regemp056 = regemp056;
		this.tipdocrepresentante056 = tipdocrepresentante056;
		this.numdocrepresentante056 = numdocrepresentante056;
		this.nomrepresentante056 = nomrepresentante056;
		this.tlfrepresentante056 = tlfrepresentante056;
		this.terape056 = terape056;
		this.forpre056 = forpre056;
		this.folderId056 = folderId056;
		this.datosNotificacion = datosNotificacion;
		this.estadoSolicitud056 = estadoSolicitud056;
		this.numregistro056 = numregistro056;
	}

	/**
	 * Method 'getIdSolicitud056'.
	 * 
	 *  Long
	 *
	 * @return the id solicitud 056
	 */

	public Long getIdSolicitud056() {
		return this.idSolicitud056;
	}

	/**
	 * Method 'setIdSolicitud056'.
	 * 
	 *  idSolicitud056
	 *            Long
	 *
	 * @param idSolicitud056 the new id solicitud 056
	 */

	public void setIdSolicitud056(Long idSolicitud056) {
		this.idSolicitud056 = idSolicitud056;
	}

	/**
	 *  Long.
	 *
	 * @return the tiposol 056
	 */
	public Long getTiposol056() {
		return this.tiposol056;
	}

	/**
	 *  tiposol056
	 *            Long.
	 *
	 * @param tiposol056 the new tiposol 056
	 */
	public void setTiposol056(Long tiposol056) {
		this.tiposol056 = tiposol056;
	}

	/**
	 * Method 'getAnoape056'.
	 * 
	 *  String
	 *
	 * @return the anoape 056
	 */

	public String getAnoape056() {
		return this.anoape056;
	}

	/**
	 * Method 'setAnoape056'.
	 * 
	 *  anoape056
	 *            String
	 *
	 * @param anoape056 the new anoape 056
	 */

	public void setAnoape056(String anoape056) {
		this.anoape056 = anoape056;
	}

	/**
	 * Method 'getNumape056'.
	 * 
	 *  Integer
	 *
	 * @return the numape 056
	 */

	public Integer getNumape056() {
		return this.numape056;
	}

	/**
	 * Method 'setNumape056'.
	 * 
	 *  numape056
	 *            Integer
	 *
	 * @param numape056 the new numape 056
	 */

	public void setNumape056(Integer numape056) {
		this.numape056 = numape056;
	}

	/**
	 * Method 'getFecpre056'.
	 * 
	 *  java.util.Date
	 *
	 * @return the fecpre 056
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecpre056() {
		return this.fecpre056;
	}

	/**
	 * Method 'setFecpre056'.
	 * 
	 *  fecpre056
	 *            java.util.Date
	 *
	 * @param fecpre056 the new fecpre 056
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecpre056(Date fecpre056) {
		this.fecpre056 = fecpre056;
	}

	/**
	 * Method 'getNueva056'.
	 * 
	 *  String
	 *
	 * @return the nueva 056
	 */

	public String getNueva056() {
		return this.nueva056;
	}

	/**
	 * Method 'setNueva056'.
	 * 
	 *  nueva056
	 *            String
	 *
	 * @param nueva056 the new nueva 056
	 */

	public void setNueva056(String nueva056) {
		this.nueva056 = nueva056;
	}

	/**
	 * Method 'getTipdoc056'.
	 * 
	 *  String
	 *
	 * @return the tipdoc 056
	 */

	public String getTipdoc056() {
		return this.tipdoc056;
	}

	/**
	 * Method 'setTipdoc056'.
	 * 
	 *  tipdoc056
	 *            String
	 *
	 * @param tipdoc056 the new tipdoc 056
	 */

	public void setTipdoc056(String tipdoc056) {
		this.tipdoc056 = tipdoc056;
	}

	/**
	 * Method 'getNumdoc056'.
	 * 
	 *  String
	 *
	 * @return the numdoc 056
	 */

	public String getNumdoc056() {
		return this.numdoc056;
	}

	/**
	 * Method 'setNumdoc056'.
	 * 
	 *  numdoc056
	 *            String
	 *
	 * @param numdoc056 the new numdoc 056
	 */

	public void setNumdoc056(String numdoc056) {
		this.numdoc056 = numdoc056;
	}

	/**
	 * Method 'getNomemp056'.
	 * 
	 *  String
	 *
	 * @return the nomemp 056
	 */

	public String getNomemp056() {
		return this.nomemp056;
	}

	/**
	 * Method 'setNomemp056'.
	 * 
	 *  nomemp056
	 *            String
	 *
	 * @param nomemp056 the new nomemp 056
	 */

	public void setNomemp056(String nomemp056) {
		this.nomemp056 = nomemp056;
	}

	/**
	 * Method 'getPaisemp056'.
	 * 
	 *  String
	 *
	 * @return the paisemp 056
	 */

	public Pais getPaisemp056() {
		return this.paisemp056;
	}

	/**
	 * Method 'setPaisemp056'.
	 * 
	 *  paisemp056
	 *            String
	 *
	 * @param paisemp056 the new paisemp 056
	 */

	public void setPaisemp056(Pais paisemp056) {
		this.paisemp056 = paisemp056;
	}

	/**
	 * Method 'getPrvemp056'.
	 * 
	 *  String
	 *
	 * @return the prvemp 056
	 */

	public Provincia getPrvemp056() {
		return this.prvemp056;
	}

	/**
	 * Method 'setPrvemp056'.
	 * 
	 *  prvemp056
	 *            String
	 *
	 * @param prvemp056 the new prvemp 056
	 */

	public void setPrvemp056(Provincia prvemp056) {
		this.prvemp056 = prvemp056;
	}

	/**
	 * Method 'getMunemp056'.
	 * 
	 *  String
	 *
	 * @return the munemp 056
	 */

	public Municipio getMunemp056() {
		return this.munemp056;
	}

	/**
	 * Method 'setMunemp056'.
	 * 
	 *  munemp056
	 *            String
	 *
	 * @param munemp056 the new munemp 056
	 */

	public void setMunemp056(Municipio munemp056) {
		this.munemp056 = munemp056;
	}

	/**
	 * Method 'getDmunemp056'.
	 * 
	 *  String
	 *
	 * @return the dmunemp 056
	 */

	public String getDmunemp056() {
		return this.dmunemp056;
	}

	/**
	 * Method 'setDmunemp056'.
	 * 
	 *  dmunemp056
	 *            String
	 *
	 * @param dmunemp056 the new dmunemp 056
	 */

	public void setDmunemp056(String dmunemp056) {
		this.dmunemp056 = dmunemp056;
	}

	/**
	 * Method 'getDiremp056'.
	 * 
	 *  String
	 *
	 * @return the diremp 056
	 */

	public String getDiremp056() {
		return this.diremp056;
	}

	/**
	 * Method 'setDiremp056'.
	 * 
	 *  diremp056
	 *            String
	 *
	 * @param diremp056 the new diremp 056
	 */

	public void setDiremp056(String diremp056) {
		this.diremp056 = diremp056;
	}

	/**
	 * Method 'getCpoemp056'.
	 * 
	 *  String
	 *
	 * @return the cpoemp 056
	 */

	public String getCpoemp056() {
		return this.cpoemp056;
	}

	/**
	 * Method 'setCpoemp056'.
	 * 
	 *  cpoemp056
	 *            String
	 *
	 * @param cpoemp056 the new cpoemp 056
	 */

	public void setCpoemp056(String cpoemp056) {
		this.cpoemp056 = cpoemp056;
	}

	/**
	 * Method 'getTlfemp056'.
	 * 
	 *  String
	 *
	 * @return the tlfemp 056
	 */

	public String getTlfemp056() {
		return this.tlfemp056;
	}

	/**
	 * Method 'setTlfemp056'.
	 * 
	 *  tlfemp056
	 *            String
	 *
	 * @param tlfemp056 the new tlfemp 056
	 */

	public void setTlfemp056(String tlfemp056) {
		this.tlfemp056 = tlfemp056;
	}

	/**
	 * Method 'getCnaeemp056'.
	 * 
	 *  String
	 *
	 * @return the cnaeemp 056
	 */

	public String getCnaeemp056() {
		return this.cnaeemp056;
	}

	/**
	 * Method 'setCnaeemp056'.
	 * 
	 *  cnaeemp056
	 *            String
	 *
	 * @param cnaeemp056 the new cnaeemp 056
	 */

	public void setCnaeemp056(String cnaeemp056) {
		this.cnaeemp056 = cnaeemp056;
	}

	/**
	 * Method 'getEntiat056'.
	 * 
	 *  String
	 *
	 * @return the entiat 056
	 */

	public String getEntiat056() {
		return this.entiat056;
	}

	/**
	 * Method 'setEntiat056'.
	 * 
	 *  entiat056
	 *            String
	 *
	 * @param entiat056 the new entiat 056
	 */

	public void setEntiat056(String entiat056) {
		this.entiat056 = entiat056;
	}

	/**
	 * Method 'getTipape056'.
	 * 
	 *  String
	 *
	 * @return the tipape 056
	 */

	public String getTipape056() {
		return this.tipape056;
	}

	/**
	 * Method 'setTipape056'.
	 * 
	 *  tipape056
	 *            String
	 *
	 * @param tipape056 the new tipape 056
	 */

	public void setTipape056(String tipape056) {
		this.tipape056 = tipape056;
	}

	/**
	 * Method 'getNomctr056'.
	 * 
	 *  String
	 *
	 * @return the nomctr 056
	 */

	public String getNomctr056() {
		return this.nomctr056;
	}

	/**
	 * Method 'setNomctr056'.
	 * 
	 *  nomctr056
	 *            String
	 *
	 * @param nomctr056 the new nomctr 056
	 */

	public void setNomctr056(String nomctr056) {
		this.nomctr056 = nomctr056;
	}

	/**
	 * Method 'getPrvctr056'.
	 * 
	 *  String
	 *
	 * @return the prvctr 056
	 */

	public Provincia getPrvctr056() {
		return this.prvctr056;
	}

	/**
	 * Method 'setPrvctr056'.
	 * 
	 *  prvctr056
	 *            String
	 *
	 * @param prvctr056 the new prvctr 056
	 */

	public void setPrvctr056(Provincia prvctr056) {
		this.prvctr056 = prvctr056;
	}

	/**
	 * Method 'getMunctr056'.
	 * 
	 *  String
	 *
	 * @return the munctr 056
	 */

	public Municipio getMunctr056() {
		return this.munctr056;
	}

	/**
	 * Method 'setMunctr056'.
	 * 
	 *  munctr056
	 *            String
	 *
	 * @param munctr056 the new munctr 056
	 */

	public void setMunctr056(Municipio munctr056) {
		this.munctr056 = munctr056;
	}

	/**
	 * Method 'getLocctr056'.
	 * 
	 *  String
	 *
	 * @return the locctr 056
	 */

	public Localidad getLocctr056() {
		return this.locctr056;
	}

	/**
	 * Method 'setLocctr056'.
	 * 
	 *  locctr056
	 *            String
	 *
	 * @param locctr056 the new locctr 056
	 */

	public void setLocctr056(Localidad locctr056) {
		this.locctr056 = locctr056;
	}

	/**
	 * Method 'getDirctr056'.
	 * 
	 *  String
	 *
	 * @return the dirctr 056
	 */

	public String getDirctr056() {
		return this.dirctr056;
	}

	/**
	 * Method 'setDirctr056'.
	 * 
	 *  dirctr056
	 *            String
	 *
	 * @param dirctr056 the new dirctr 056
	 */

	public void setDirctr056(String dirctr056) {
		this.dirctr056 = dirctr056;
	}

	/**
	 * Method 'getCpoctr056'.
	 * 
	 *  String
	 *
	 * @return the cpoctr 056
	 */

	public String getCpoctr056() {
		return this.cpoctr056;
	}

	/**
	 * Method 'setCpoctr056'.
	 * 
	 *  cpoctr056
	 *            String
	 *
	 * @param cpoctr056 the new cpoctr 056
	 */

	public void setCpoctr056(String cpoctr056) {
		this.cpoctr056 = cpoctr056;
	}

	/**
	 * Method 'getTlfctr056'.
	 * 
	 *  String
	 *
	 * @return the tlfctr 056
	 */

	public String getTlfctr056() {
		return this.tlfctr056;
	}

	/**
	 * Method 'setTlfctr056'.
	 * 
	 *  tlfctr056
	 *            String
	 *
	 * @param tlfctr056 the new tlfctr 056
	 */

	public void setTlfctr056(String tlfctr056) {
		this.tlfctr056 = tlfctr056;
	}

	/**
	 * Method 'getFaxctr056'.
	 * 
	 *  String
	 *
	 * @return the faxctr 056
	 */

	public String getFaxctr056() {
		return this.faxctr056;
	}

	/**
	 * Method 'setFaxctr056'.
	 * 
	 *  faxctr056
	 *            String
	 *
	 * @param faxctr056 the new faxctr 056
	 */

	public void setFaxctr056(String faxctr056) {
		this.faxctr056 = faxctr056;
	}

	/**
	 * Method 'getEmailctr056'.
	 * 
	 *  String
	 *
	 * @return the emailctr 056
	 */

	public String getEmailctr056() {
		return this.emailctr056;
	}

	/**
	 * Method 'setEmailctr056'.
	 * 
	 *  emailctr056
	 *            String
	 *
	 * @param emailctr056 the new emailctr 056
	 */

	public void setEmailctr056(String emailctr056) {
		this.emailctr056 = emailctr056;
	}

	/**
	 * Method 'getCnaectr056'.
	 * 
	 *  String
	 *
	 * @return the cnaectr 056
	 */

	public String getCnaectr056() {
		return this.cnaectr056;
	}

	/**
	 * Method 'setCnaectr056'.
	 * 
	 *  cnaectr056
	 *            String
	 *
	 * @param cnaectr056 the new cnaectr 056
	 */

	public void setCnaectr056(String cnaectr056) {
		this.cnaectr056 = cnaectr056;
	}

	/**
	 * Method 'getPrvss056'.
	 * 
	 *  String
	 *
	 * @return the prvss 056
	 */

	public String getPrvss056() {
		return this.prvss056;
	}

	/**
	 * Method 'setPrvss056'.
	 * 
	 *  prvss056
	 *            String
	 *
	 * @param prvss056 the new prvss 056
	 */

	public void setPrvss056(String prvss056) {
		this.prvss056 = prvss056;
	}

	/**
	 * Method 'getNumss056'.
	 * 
	 *  String
	 *
	 * @return the numss 056
	 */

	public String getNumss056() {
		return this.numss056;
	}

	/**
	 * Method 'setNumss056'.
	 * 
	 *  numss056
	 *            String
	 *
	 * @param numss056 the new numss 056
	 */

	public void setNumss056(String numss056) {
		this.numss056 = numss056;
	}

	/**
	 * Method 'getDigss056'.
	 * 
	 *  String
	 *
	 * @return the digss 056
	 */

	public String getDigss056() {
		return this.digss056;
	}

	/**
	 * Method 'setDigss056'.
	 * 
	 *  digss056
	 *            String
	 *
	 * @param digss056 the new digss 056
	 */

	public void setDigss056(String digss056) {
		this.digss056 = digss056;
	}

	/**
	 * Method 'getFecini056'.
	 * 
	 *  java.util.Date
	 *
	 * @return the fecini 056
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecini056() {
		return this.fecini056;
	}

	/**
	 * Method 'setFecini056'.
	 * 
	 *  fecini056
	 *            java.util.Date
	 *
	 * @param fecini056 the new fecini 056
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecini056(Date fecini056) {
		this.fecini056 = fecini056;
	}

	/**
	 * Method 'getTrbhom056'.
	 * 
	 *  Long
	 *
	 * @return the trbhom 056
	 */

	public Long getTrbhom056() {
		return this.trbhom056;
	}

	/**
	 * Method 'setTrbhom056'.
	 * 
	 *  trbhom056
	 *            Long
	 *
	 * @param trbhom056 the new trbhom 056
	 */

	public void setTrbhom056(Long trbhom056) {
		this.trbhom056 = trbhom056;
	}

	/**
	 * Method 'getTrbmuj056'.
	 * 
	 *  Long
	 *
	 * @return the trbmuj 056
	 */

	public Long getTrbmuj056() {
		return this.trbmuj056;
	}

	/**
	 * Method 'setTrbmuj056'.
	 * 
	 *  trbmuj056
	 *            Long
	 *
	 * @param trbmuj056 the new trbmuj 056
	 */

	public void setTrbmuj056(Long trbmuj056) {
		this.trbmuj056 = trbmuj056;
	}

	/**
	 * Method 'getTrbtot056'.
	 * 
	 *  Long
	 *
	 * @return the trbtot 056
	 */

	public Long getTrbtot056() {
		return this.trbtot056;
	}

	/**
	 * Method 'setTrbtot056'.
	 * 
	 *  trbtot056
	 *            Long
	 *
	 * @param trbtot056 the new trbtot 056
	 */

	public void setTrbtot056(Long trbtot056) {
		this.trbtot056 = trbtot056;
	}

	/**
	 * Method 'getClasctr056'.
	 * 
	 *  String
	 *
	 * @return the clasctr 056
	 */

	public String getClasctr056() {
		return this.clasctr056;
	}

	/**
	 * Method 'setClasctr056'.
	 * 
	 *  clasctr056
	 *            String
	 *
	 * @param clasctr056 the new clasctr 056
	 */

	public void setClasctr056(String clasctr056) {
		this.clasctr056 = clasctr056;
	}

	/**
	 * Method 'getDescobr056'.
	 * 
	 *  String
	 *
	 * @return the descobr 056
	 */

	public String getDescobr056() {
		return this.descobr056;
	}

	/**
	 * Method 'setDescobr056'.
	 * 
	 *  descobr056
	 *            String
	 *
	 * @param descobr056 the new descobr 056
	 */

	public void setDescobr056(String descobr056) {
		this.descobr056 = descobr056;
	}

	/**
	 * Method 'getSuperf056'.
	 * 
	 *  Integer
	 *
	 * @return the superf 056
	 */

	public Integer getSuperf056() {
		return this.superf056;
	}

	/**
	 * Method 'setSuperf056'.
	 * 
	 *  superf056
	 *            Integer
	 *
	 * @param superf056 the new superf 056
	 */

	public void setSuperf056(Integer superf056) {
		this.superf056 = superf056;
	}

	/**
	 * Method 'getPlanseg056'.
	 * 
	 *  String
	 *
	 * @return the planseg 056
	 */

	public String getPlanseg056() {
		return this.planseg056;
	}

	/**
	 * Method 'setPlanseg056'.
	 * 
	 *  planseg056
	 *            String
	 *
	 * @param planseg056 the new planseg 056
	 */

	public void setPlanseg056(String planseg056) {
		this.planseg056 = planseg056;
	}

	/**
	 * Method 'getCanalplan056'.
	 * 
	 *  String
	 *
	 * @return the canalplan 056
	 */

	public String getCanalplan056() {
		return this.canalplan056;
	}

	/**
	 * Method 'setCanalplan056'.
	 * 
	 *  canalplan056
	 *            String
	 *
	 * @param canalplan056 the new canalplan 056
	 */

	public void setCanalplan056(String canalplan056) {
		this.canalplan056 = canalplan056;
	}

	/**
	 * Method 'getPlanpres056'.
	 * 
	 *  String
	 *
	 * @return the planpres 056
	 */

	public String getPlanpres056() {
		return this.planpres056;
	}

	/**
	 * Method 'setPlanpres056'.
	 * 
	 *  planpres056
	 *            String
	 *
	 * @param planpres056 the new planpres 056
	 */

	public void setPlanpres056(String planpres056) {
		this.planpres056 = planpres056;
	}

	/**
	 * Method 'getProytec056'.
	 * 
	 *  String
	 *
	 * @return the proytec 056
	 */

	public String getProytec056() {
		return this.proytec056;
	}

	/**
	 * Method 'setProytec056'.
	 * 
	 *  proytec056
	 *            String
	 *
	 * @param proytec056 the new proytec 056
	 */

	public void setProytec056(String proytec056) {
		this.proytec056 = proytec056;
	}

	/**
	 * Method 'getDescmaq056'.
	 * 
	 *  String
	 *
	 * @return the descmaq 056
	 */

	public String getDescmaq056() {
		return this.descmaq056;
	}

	/**
	 * Method 'setDescmaq056'.
	 * 
	 *  descmaq056
	 *            String
	 *
	 * @param descmaq056 the new descmaq 056
	 */

	public void setDescmaq056(String descmaq056) {
		this.descmaq056 = descmaq056;
	}

	/**
	 * Method 'getPoten056'.
	 * 
	 *  BigDecimal
	 *
	 * @return the poten 056
	 */

	public BigDecimal getPoten056() {
		return this.poten056;
	}

	/**
	 * Method 'setPoten056'.
	 * 
	 *  poten056
	 *            BigDecimal
	 *
	 * @param poten056 the new poten 056
	 */

	public void setPoten056(BigDecimal poten056) {
		this.poten056 = poten056;
	}

	/**
	 * Method 'getIndanx056'.
	 * 
	 *  String
	 *
	 * @return the indanx 056
	 */

	public String getIndanx056() {
		return this.indanx056;
	}

	/**
	 * Method 'setIndanx056'.
	 * 
	 *  indanx056
	 *            String
	 *
	 * @param indanx056 the new indanx 056
	 */

	public void setIndanx056(String indanx056) {
		this.indanx056 = indanx056;
	}

	/**
	 * Method 'getApdoanx056'.
	 * 
	 *  String
	 *
	 * @return the apdoanx 056
	 */

	public String getApdoanx056() {
		return this.apdoanx056;
	}

	/**
	 * Method 'setApdoanx056'.
	 * 
	 *  apdoanx056
	 *            String
	 *
	 * @param apdoanx056 the new apdoanx 056
	 */

	public void setApdoanx056(String apdoanx056) {
		this.apdoanx056 = apdoanx056;
	}

	/**
	 * Method 'getDestrab056'.
	 * 
	 *  String
	 *
	 * @return the destrab 056
	 */

	public String getDestrab056() {
		return this.destrab056;
	}

	/**
	 * Method 'setDestrab056'.
	 * 
	 *  destrab056
	 *            String
	 *
	 * @param destrab056 the new destrab 056
	 */

	public void setDestrab056(String destrab056) {
		this.destrab056 = destrab056;
	}

	/**
	 * Method 'getIndobra056'.
	 * 
	 *  String
	 *
	 * @return the indobra 056
	 */

	public String getIndobra056() {
		return this.indobra056;
	}

	/**
	 * Method 'setIndobra056'.
	 * 
	 *  indobra056
	 *            String
	 *
	 * @param indobra056 the new indobra 056
	 */

	public void setIndobra056(String indobra056) {
		this.indobra056 = indobra056;
	}

	/**
	 * Method 'getObra'.
	 * 
	 *  SolicObra
	 *
	 * @return the obra
	 */

	public SolicObra getObra() {
		return this.obra;
	}

	/**
	 * Method 'setObra'.
	 * 
	 *  obra
	 *            SolicObra
	 *
	 * @param obra the new obra
	 */

	public void setObra(SolicObra obra) {
		this.obra = obra;
	}

	/**
	 * Method 'getCodctr056'.
	 * 
	 *  Integer
	 *
	 * @return the codctr 056
	 */

	public Integer getCodctr056() {
		return this.codctr056;
	}

	/**
	 * Method 'setCodctr056'.
	 * 
	 *  codctr056
	 *            Integer
	 *
	 * @param codctr056 the new codctr 056
	 */

	public void setCodctr056(Integer codctr056) {
		this.codctr056 = codctr056;
	}

	/**
	 * Method 'getLotemnt056'.
	 * 
	 *  String
	 *
	 * @return the lotemnt 056
	 */

	public String getLotemnt056() {
		return this.lotemnt056;
	}

	/**
	 * Method 'setLotemnt056'.
	 * 
	 *  lotemnt056
	 *            String
	 *
	 * @param lotemnt056 the new lotemnt 056
	 */

	public void setLotemnt056(String lotemnt056) {
		this.lotemnt056 = lotemnt056;
	}

	/**
	 * Method 'getAsgosl056'.
	 * 
	 *  String
	 *
	 * @return the asgosl 056
	 */

	public String getAsgosl056() {
		return this.asgosl056;
	}

	/**
	 * Method 'setAsgosl056'.
	 * 
	 *  asgosl056
	 *            String
	 *
	 * @param asgosl056 the new asgosl 056
	 */

	public void setAsgosl056(String asgosl056) {
		this.asgosl056 = asgosl056;
	}

	/**
	 * Method 'getCodentiat056'.
	 * 
	 *  String
	 *
	 * @return the codentiat 056
	 */

	public String getCodentiat056() {
		return this.codentiat056;
	}

	/**
	 * Method 'setCodentiat056'.
	 * 
	 *  codentiat056
	 *            String
	 *
	 * @param codentiat056 the new codentiat 056
	 */

	public void setCodentiat056(String codentiat056) {
		this.codentiat056 = codentiat056;
	}

	/**
	 * Method 'getCnaectr93056'.
	 * 
	 *  String
	 *
	 * @return the cnaectr 93056
	 */

	public String getCnaectr93056() {
		return this.cnaectr93056;
	}

	/**
	 * Method 'setCnaectr93056'.
	 * 
	 *  cnaectr93056
	 *            String
	 *
	 * @param cnaectr93056 the new cnaectr 93056
	 */

	public void setCnaectr93056(String cnaectr93056) {
		this.cnaectr93056 = cnaectr93056;
	}

	/**
	 * Method 'getCnaeemp93056'.
	 * 
	 *  String
	 *
	 * @return the cnaeemp 93056
	 */

	public String getCnaeemp93056() {
		return this.cnaeemp93056;
	}

	/**
	 * Method 'setCnaeemp93056'.
	 * 
	 *  cnaeemp93056
	 *            String
	 *
	 * @param cnaeemp93056 the new cnaeemp 93056
	 */

	public void setCnaeemp93056(String cnaeemp93056) {
		this.cnaeemp93056 = cnaeemp93056;
	}

	/**
	 * Method 'getModpre056'.
	 * 
	 *  Integer
	 *
	 * @return the modpre 056
	 */

	public Integer getModpre056() {
		return this.modpre056;
	}

	/**
	 * Method 'setModpre056'.
	 * 
	 *  modpre056
	 *            Integer
	 *
	 * @param modpre056 the new modpre 056
	 */

	public void setModpre056(Integer modpre056) {
		this.modpre056 = modpre056;
	}

	/**
	 * Method 'getNumcnt056'.
	 * 
	 *  Long
	 *
	 * @return the numcnt 056
	 */

	public Long getNumcnt056() {
		return this.numcnt056;
	}

	/**
	 * Method 'setNumcnt056'.
	 * 
	 *  numcnt056
	 *            Long
	 *
	 * @param numcnt056 the new numcnt 056
	 */

	public void setNumcnt056(Long numcnt056) {
		this.numcnt056 = numcnt056;
	}

	/**
	 * Method 'getEvalpres056'.
	 * 
	 *  String
	 *
	 * @return the evalpres 056
	 */

	public String getEvalpres056() {
		return this.evalpres056;
	}

	/**
	 * Method 'setEvalpres056'.
	 * 
	 *  evalpres056
	 *            String
	 *
	 * @param evalpres056 the new evalpres 056
	 */

	public void setEvalpres056(String evalpres056) {
		this.evalpres056 = evalpres056;
	}

	/**
	 * Method 'getCanaleval056'.
	 * 
	 *  String
	 *
	 * @return the canaleval 056
	 */

	public String getCanaleval056() {
		return this.canaleval056;
	}

	/**
	 * Method 'setCanaleval056'.
	 * 
	 *  canaleval056
	 *            String
	 *
	 * @param canaleval056 the new canaleval 056
	 */

	public void setCanaleval056(String canaleval056) {
		this.canaleval056 = canaleval056;
	}

	/**
	 * Method 'getRegemp056'.
	 * 
	 *  String
	 *
	 * @return the regemp 056
	 */

	public String getRegemp056() {
		return this.regemp056;
	}

	/**
	 * Method 'getRegemp056'.
	 * 
	 *  String
	 *
	 * @return the regemp 056 completo
	 */
	public String getRegemp056Completo() {
		if (this.regemp1 != null && this.regemp2 != null
				&& this.regemp3 != null) {
			this.regemp1 = Utilities.rellenarCeros(this.regemp1,
					ConstantesNum.NUM_2);
			this.regemp2 = Utilities.rellenarCeros(this.regemp2,
					ConstantesNum.NUM_2);
			this.regemp3 = Utilities.rellenarCeros(this.regemp3,
					ConstantesNum.NUM_7);
			return this.regemp1 + "/" + this.regemp2 + "/" + this.regemp3;
		} else {
			return "";
		}
	}

	/**
	 * Method 'setRegemp056'.
	 * 
	 *  regemp056
	 *            String
	 *
	 * @param regemp056 the new regemp 056
	 */

	public void setRegemp056(String regemp056) {
		this.regemp056 = regemp056;
	}

	/**
	 * Method 'getNumdocrepresentante056'.
	 * 
	 *  String
	 *
	 * @return the numdocrepresentante 056
	 */

	public String getNumdocrepresentante056() {
		return this.numdocrepresentante056;
	}

	/**
	 * Method 'setNumdocrepresentante056'.
	 * 
	 *  numdocrepresentante056
	 *            String
	 *
	 * @param numdocrepresentante056 the new numdocrepresentante 056
	 */

	public void setNumdocrepresentante056(String numdocrepresentante056) {
		this.numdocrepresentante056 = numdocrepresentante056;
	}

	/**
	 * Method 'getTlfrepresentante056'.
	 * 
	 *  String
	 *
	 * @return the tlfrepresentante 056
	 */

	public String getTlfrepresentante056() {
		return this.tlfrepresentante056;
	}

	/**
	 * Method 'setTlfrepresentante056'.
	 * 
	 *  tlfrepresentante056
	 *            String
	 *
	 * @param tlfrepresentante056 the new tlfrepresentante 056
	 */

	public void setTlfrepresentante056(String tlfrepresentante056) {
		this.tlfrepresentante056 = tlfrepresentante056;
	}

	/**
	 * Method 'getTerape056'.
	 * 
	 *  String
	 *
	 * @return the terape 056
	 */

	public String getTerape056() {
		return this.terape056;
	}

	/**
	 * Method 'setTerape056'.
	 * 
	 *  terape056
	 *            String
	 *
	 * @param terape056 the new terape 056
	 */

	public void setTerape056(String terape056) {
		this.terape056 = terape056;
	}

	/**
	 * Method 'getForpre056'.
	 * 
	 *  String
	 *
	 * @return the forpre 056
	 */

	public String getForpre056() {
		return this.forpre056;
	}

	/**
	 * Method 'setForpre056'.
	 * 
	 *  forpre056
	 *            String
	 *
	 * @param forpre056 the new forpre 056
	 */

	public void setForpre056(String forpre056) {
		this.forpre056 = forpre056;
	}

	/**
	 * Method 'getFolderId056'.
	 * 
	 *  String
	 *
	 * @return the folder id 056
	 */

	public String getFolderId056() {
		return this.folderId056;
	}

	/**
	 * Method 'setFolderId056'.
	 * 
	 *  folderId056
	 *            String
	 *
	 * @param folderId056 the new folder id 056
	 */

	public void setFolderId056(String folderId056) {
		this.folderId056 = folderId056;
	}

	/**
	 * Method 'getDatosNotificacion'.
	 * 
	 *  SolicDatosNotificacion
	 *
	 * @return the datos notificacion
	 */

	public SolicDatosNotificacion getDatosNotificacion() {
		return this.datosNotificacion;
	}

	/**
	 * Method 'setDatosNotificacion'.
	 * 
	 *  datosNotificacion
	 *            SolicDatosNotificacion
	 *
	 * @param datosNotificacion the new datos notificacion
	 */

	public void setDatosNotificacion(SolicDatosNotificacion datosNotificacion) {
		this.datosNotificacion = datosNotificacion;
	}

	/**
	 * Method 'getEstadoSolicitud056'.
	 * 
	 *  String
	 *
	 * @return the estado solicitud 056
	 */

	public String getEstadoSolicitud056() {
		return this.estadoSolicitud056;
	}

	/**
	 * Method 'setEstadoSolicitud056'.
	 * 
	 *  estadoSolicitud056
	 *            String
	 *
	 * @param estadoSolicitud056 the new estado solicitud 056
	 */

	public void setEstadoSolicitud056(String estadoSolicitud056) {
		this.estadoSolicitud056 = estadoSolicitud056;
	}

	/**
	 *  String.
	 *
	 * @return the titrepr 056
	 */
	public String getTitrepr056() {
		return this.titrepr056;
	}

	/**
	 *  titrepr056
	 *            String.
	 *
	 * @param titrepr056 the new titrepr 056
	 */
	public void setTitrepr056(String titrepr056) {
		this.titrepr056 = titrepr056;
	}

	/**
	 *  String.
	 *
	 * @return the tipdocrepresentante 056
	 */
	public String getTipdocrepresentante056() {
		return this.tipdocrepresentante056;
	}

	/**
	 *  tipdocrepresentante056
	 *            String.
	 *
	 * @param tipdocrepresentante056 the new tipdocrepresentante 056
	 */
	public void setTipdocrepresentante056(String tipdocrepresentante056) {
		this.tipdocrepresentante056 = tipdocrepresentante056;
	}

	/**
	 *  String.
	 *
	 * @return the nomrepresentante 056
	 */
	public String getNomrepresentante056() {
		return this.nomrepresentante056;
	}

	/**
	 *  nomrepresentante056
	 *            String.
	 *
	 * @param nomrepresentante056 the new nomrepresentante 056
	 */
	public void setNomrepresentante056(String nomrepresentante056) {
		this.nomrepresentante056 = nomrepresentante056;
	}

	/**
	 *  String.
	 *
	 * @return the numregistro 056
	 */
	public String getNumregistro056() {
		return this.numregistro056;
	}

	/**
	 *  numregistro056
	 *            String.
	 *
	 * @param numregistro056 the new numregistro 056
	 */
	public void setNumregistro056(String numregistro056) {
		this.numregistro056 = numregistro056;
	}

	/**
	 *  List<SolicDocAperturas>.
	 *
	 * @return the lista documentos
	 */
	public List<SolicDocAperturas> getListaDocumentos() {
		return this.listaDocumentos;
	}

	/**
	 *  listaDocumentos
	 *            List<SolicDocAperturas>.
	 *
	 * @param listaDocumentos the new lista documentos
	 */
	public void setListaDocumentos(List<SolicDocAperturas> listaDocumentos) {
		this.listaDocumentos = listaDocumentos;
	}

	/**
	 *  List<SolicProyectista>.
	 *
	 * @return the lista proyectistas
	 */
	public List<SolicProyectista> getListaProyectistas() {
		return this.listaProyectistas;
	}

	/**
	 *  listaProyectistas
	 *            List<SolicProyectista>.
	 *
	 * @param listaProyectistas the new lista proyectistas
	 */
	public void setListaProyectistas(List<SolicProyectista> listaProyectistas) {
		this.listaProyectistas = listaProyectistas;
	}

	/**
	 *  List<SolicCoordinador.
	 *
	 * @return the lista coordinadores P
	 */
	public List<SolicCoordinador> getListaCoordinadoresP() {
		return this.listaCoordinadoresP;
	}

	/**
	 *  listaCoordinadores
	 *            List<SolicCoordinador.
	 *
	 * @param listaCoordinadores the new lista coordinadores P
	 */
	public void setListaCoordinadoresP(List<SolicCoordinador> listaCoordinadores) {
		this.listaCoordinadoresP = listaCoordinadores;
	}

	/**
	 *  List<SolicPromotor>.
	 *
	 * @return the lista promotores
	 */
	public List<SolicPromotor> getListaPromotores() {
		return this.listaPromotores;
	}

	/**
	 *  listaPromotores
	 *            List<SolicPromotor>.
	 *
	 * @param listaPromotores the new lista promotores
	 */
	public void setListaPromotores(List<SolicPromotor> listaPromotores) {
		this.listaPromotores = listaPromotores;
	}

	/**
	 *  List<SolicDatosAviso>.
	 *
	 * @return the lista datos aviso
	 */
	public List<SolicDatosAviso> getListaDatosAviso() {
		return this.listaDatosAviso;
	}

	/**
	 *  listaDatosAviso
	 *            List<SolicDatosAviso>.
	 *
	 * @param listaDatosAviso the new lista datos aviso
	 */
	public void setListaDatosAviso(List<SolicDatosAviso> listaDatosAviso) {
		this.listaDatosAviso = listaDatosAviso;
	}

	/**
	 * Devuelve el número de documento del solicitante o de la empresa en
	 * función de si es titular o representante
	 * 
	 *  String.
	 *
	 * @return the num doc solicitante
	 */
	public String getNumDocSolicitante() {
		if (Constantes.SOLICITANTE_TITULAR.equals(this.titrepr056)) {
			return this.numdoc056;
		}
		if (Constantes.SOLICITANTE_REPRESENTANTE.equals(this.titrepr056)) {
			return this.numdocrepresentante056;
		} else {
			return null;
		}
	}

	/**
	 * Devuelve el tipo de documento del solicitante o de la empresa en función
	 * de si es titular o representante
	 * 
	 *  String.
	 *
	 * @return the tipo doc solicitante
	 */
	public String getTipoDocSolicitante() {
		if (Constantes.SOLICITANTE_TITULAR.equals(this.titrepr056)) {
			return this.tipdoc056;
		}
		if (Constantes.SOLICITANTE_REPRESENTANTE.equals(this.titrepr056)) {
			return this.tipdocrepresentante056;
		} else {
			return null;
		}
	}

	/**
	 * Devuelve el nombre del solicitante o de la empresa en función de si es
	 * titular o representante
	 * 
	 *  String.
	 *
	 * @return the nombre solicitante
	 */
	public String getNombreSolicitante() {
		if (Constantes.SOLICITANTE_TITULAR.equals(this.titrepr056)) {
			return this.nomemp056;
		}
		if (Constantes.SOLICITANTE_REPRESENTANTE.equals(this.titrepr056)) {
			return this.nomrepresentante056;
		} else {
			return null;
		}
	}

	/**
	 *  boolean.
	 *
	 * @return true, if is filtro borradores usuario
	 */
	public boolean isFiltroBorradoresUsuario() {
		return this.filtroBorradoresUsuario;
	}

	/**
	 *  filtroBorradoresUsuario
	 *            boolean.
	 *
	 * @param filtroBorradoresUsuario the new filtro borradores usuario
	 */
	public void setFiltroBorradoresUsuario(boolean filtroBorradoresUsuario) {
		this.filtroBorradoresUsuario = filtroBorradoresUsuario;
	}

	/**
	 *  String.
	 *
	 * @return the filtro nif usuario
	 */
	public String getFiltroNifUsuario() {
		return this.filtroNifUsuario;
	}

	/**
	 *  filtroNifUsuario
	 *            String.
	 *
	 * @param filtroNifUsuario the new filtro nif usuario
	 */
	public void setFiltroNifUsuario(String filtroNifUsuario) {
		this.filtroNifUsuario = filtroNifUsuario;
	}

	/**
	 *  String.
	 *
	 * @return the string
	 */
	public String obtenerTerritorioSolicitud() {
		if (Constantes.VALUE_SI.equals(this.indobra056)) {
			// Es obra. Consultamos territorio de la obra
			return this.obra.getPrvobr082().getCodProvincia();
		} else {
			// Es centro. Consultamos territorio del centro
			return this.prvctr056.getCodProvincia();
		}
	}

	/**
	 * Gets the regemp 1.
	 *
	 * @return the regemp 1
	 */
	public String getRegemp1() {
		return regemp1;
	}

	/**
	 * Sets the regemp 1.
	 *
	 * @param regemp1 the new regemp 1
	 */
	public void setRegemp1(String regemp1) {
		this.regemp1 = regemp1;
	}

	/**
	 * Gets the regemp 2.
	 *
	 * @return the regemp 2
	 */
	public String getRegemp2() {
		return regemp2;
	}

	/**
	 * Sets the regemp 2.
	 *
	 * @param regemp2 the new regemp 2
	 */
	public void setRegemp2(String regemp2) {
		this.regemp2 = regemp2;
	}

	/**
	 * Gets the regemp 3.
	 *
	 * @return the regemp 3
	 */
	public String getRegemp3() {
		return regemp3;
	}

	/**
	 * Sets the regemp 3.
	 *
	 * @param regemp3 the new regemp 3
	 */
	public void setRegemp3(String regemp3) {
		this.regemp3 = regemp3;
	}

	/**
	 * Gets the lista coordinadores E.
	 *
	 * @return the lista coordinadores E
	 */
	public List<SolicCoordinador> getListaCoordinadoresE() {
		return listaCoordinadoresE;
	}

	/**
	 * Sets the lista coordinadores E.
	 *
	 * @param listaCoordinadoresE the new lista coordinadores E
	 */
	public void setListaCoordinadoresE(
			List<SolicCoordinador> listaCoordinadoresE) {
		this.listaCoordinadoresE = listaCoordinadoresE;
	}

	/**
	 * Gets the desc cnae emp.
	 *
	 * @return the desc cnae emp
	 */
	public String getDescCnaeEmp() {
		return descCnaeEmp;
	}

	/**
	 * Sets the desc cnae emp.
	 *
	 * @param descCnaeEmp the new desc cnae emp
	 */
	public void setDescCnaeEmp(String descCnaeEmp) {
		this.descCnaeEmp = descCnaeEmp;
	}

	/**
	 * Gets the desc cnae ctr.
	 *
	 * @return the desc cnae ctr
	 */
	public String getDescCnaeCtr() {
		return descCnaeCtr;
	}

	/**
	 * Sets the desc cnae ctr.
	 *
	 * @param descCnaeCtr the new desc cnae ctr
	 */
	public void setDescCnaeCtr(String descCnaeCtr) {
		this.descCnaeCtr = descCnaeCtr;
	}

	/**
	 * Gets the clase centro.
	 *
	 * @return the clase centro
	 */
	public ClaseCentroTrabajo getClaseCentro() {
		return claseCentro;
	}

	/**
	 * Sets the clase centro.
	 *
	 * @param claseCentro the new clase centro
	 */
	public void setClaseCentro(ClaseCentroTrabajo claseCentro) {
		this.claseCentro = claseCentro;
	}

	/**
	 * Gets the modalidad org prev.
	 *
	 * @return the modalidad org prev
	 */
	public ModalidadOrganizacionPreventiva getModalidadOrgPrev() {
		return modalidadOrgPrev;
	}

	/**
	 * Sets the modalidad org prev.
	 *
	 * @param modalidadOrgPrev the new modalidad org prev
	 */
	public void setModalidadOrgPrev(
			ModalidadOrganizacionPreventiva modalidadOrgPrev) {
		this.modalidadOrgPrev = modalidadOrgPrev;
	}

	/**
	 * Gets the anexo I.
	 *
	 * @return the anexo I
	 */
	public ApartadoAnexoI getAnexoI() {
		return anexoI;
	}

	/**
	 * Sets the anexo I.
	 *
	 * @param anexoI the new anexo I
	 */
	public void setAnexoI(ApartadoAnexoI anexoI) {
		this.anexoI = anexoI;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idSolicitud056: ").append(this.idSolicitud056)
				.append(" ]");
		result.append(", [ anoape056: ").append(this.anoape056).append(" ]");
		result.append(", [ numape056: ").append(this.numape056).append(" ]");
		result.append(", [ fecpre056: ").append(this.fecpre056).append(" ]");
		result.append(", [ nueva056: ").append(this.nueva056).append(" ]");
		result.append(", [ tipdoc056: ").append(this.tipdoc056).append(" ]");
		result.append(", [ numdoc056: ").append(this.numdoc056).append(" ]");
		result.append(", [ nomemp056: ").append(this.nomemp056).append(" ]");
		result.append(", [ paisemp056: ").append(this.paisemp056).append(" ]");
		result.append(", [ prvemp056: ").append(this.prvemp056).append(" ]");
		result.append(", [ munemp056: ").append(this.munemp056).append(" ]");
		result.append(", [ dmunemp056: ").append(this.dmunemp056).append(" ]");
		result.append(", [ diremp056: ").append(this.diremp056).append(" ]");
		result.append(", [ cpoemp056: ").append(this.cpoemp056).append(" ]");
		result.append(", [ tlfemp056: ").append(this.tlfemp056).append(" ]");
		result.append(", [ cnaeemp056: ").append(this.cnaeemp056).append(" ]");
		result.append(", [ entiat056: ").append(this.entiat056).append(" ]");
		result.append(", [ tipape056: ").append(this.tipape056).append(" ]");
		result.append(", [ nomctr056: ").append(this.nomctr056).append(" ]");
		result.append(", [ prvctr056: ").append(this.prvctr056).append(" ]");
		result.append(", [ munctr056: ").append(this.munctr056).append(" ]");
		result.append(", [ locctr056: ").append(this.locctr056).append(" ]");
		result.append(", [ dirctr056: ").append(this.dirctr056).append(" ]");
		result.append(", [ cpoctr056: ").append(this.cpoctr056).append(" ]");
		result.append(", [ tlfctr056: ").append(this.tlfctr056).append(" ]");
		result.append(", [ faxctr056: ").append(this.faxctr056).append(" ]");
		result.append(", [ emailctr056: ").append(this.emailctr056)
				.append(" ]");
		result.append(", [ cnaectr056: ").append(this.cnaectr056).append(" ]");
		result.append(", [ prvss056: ").append(this.prvss056).append(" ]");
		result.append(", [ numss056: ").append(this.numss056).append(" ]");
		result.append(", [ digss056: ").append(this.digss056).append(" ]");
		result.append(", [ fecini056: ").append(this.fecini056).append(" ]");
		result.append(", [ trbhom056: ").append(this.trbhom056).append(" ]");
		result.append(", [ trbmuj056: ").append(this.trbmuj056).append(" ]");
		result.append(", [ trbtot056: ").append(this.trbtot056).append(" ]");
		result.append(", [ clasctr056: ").append(this.clasctr056).append(" ]");
		result.append(", [ descobr056: ").append(this.descobr056).append(" ]");
		result.append(", [ superf056: ").append(this.superf056).append(" ]");
		result.append(", [ planseg056: ").append(this.planseg056).append(" ]");
		result.append(", [ canalplan056: ").append(this.canalplan056)
				.append(" ]");
		result.append(", [ planpres056: ").append(this.planpres056)
				.append(" ]");
		result.append(", [ proytec056: ").append(this.proytec056).append(" ]");
		result.append(", [ descmaq056: ").append(this.descmaq056).append(" ]");
		result.append(", [ poten056: ").append(this.poten056).append(" ]");
		result.append(", [ indanx056: ").append(this.indanx056).append(" ]");
		result.append(", [ apdoanx056: ").append(this.apdoanx056).append(" ]");
		result.append(", [ destrab056: ").append(this.destrab056).append(" ]");
		result.append(", [ indobra056: ").append(this.indobra056).append(" ]");
		result.append(", [ codobra056: ").append(this.obra).append(" ]");
		result.append(", [ codctr056: ").append(this.codctr056).append(" ]");
		result.append(", [ lotemnt056: ").append(this.lotemnt056).append(" ]");
		result.append(", [ asgosl056: ").append(this.asgosl056).append(" ]");
		result.append(", [ codentiat056: ").append(this.codentiat056)
				.append(" ]");
		result.append(", [ cnaectr93056: ").append(this.cnaectr93056)
				.append(" ]");
		result.append(", [ cnaeemp93056: ").append(this.cnaeemp93056)
				.append(" ]");
		result.append(", [ modpre056: ").append(this.modpre056).append(" ]");
		result.append(", [ numcnt056: ").append(this.numcnt056).append(" ]");
		result.append(", [ evalpres056: ").append(this.evalpres056)
				.append(" ]");
		result.append(", [ canaleval056: ").append(this.canaleval056)
				.append(" ]");
		result.append(", [ regemp056: ").append(this.regemp056).append(" ]");
		result.append(", [ numdocrepresentante056: ")
				.append(this.numdocrepresentante056).append(" ]");
		result.append(", [ tlfrepresentante056: ")
				.append(this.tlfrepresentante056).append(" ]");
		result.append(", [ terape056: ").append(this.terape056).append(" ]");
		result.append(", [ forpre056: ").append(this.forpre056).append(" ]");
		result.append(", [ folderId056: ").append(this.folderId056)
				.append(" ]");
		result.append(", [ codDatosNotif056: ").append(this.datosNotificacion)
				.append(" ]");
		result.append(", [ estadoSolicitud056: ")
				.append(this.estadoSolicitud056).append(" ]");
		result.append("}");
		return result.toString();
	}

}
